/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.demo;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.demo.DemoFrame;
import com.formdev.flatlaf.demo.DemoPrefs;
import com.formdev.flatlaf.extras.FlatInspector;
import com.formdev.flatlaf.extras.FlatUIDefaultsInspector;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Dimension;
import javax.swing.SwingUtilities;

public class FlatLafDemo {
    static final String PREFS_ROOT_PATH = "/flatlaf-demo";
    static final String KEY_TAB = "tab";
    static boolean screenshotsMode = Boolean.parseBoolean(System.getProperty("flatlaf.demo.screenshotsMode"));

    public static void main(String[] args) {
        if (SystemInfo.isMacOS) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.name", "FlatLaf Demo");
            System.setProperty("apple.awt.application.appearance", "system");
        }
        if (screenshotsMode && !SystemInfo.isJava_9_orLater && System.getProperty("flatlaf.uiScale") == null) {
            System.setProperty("flatlaf.uiScale", "2x");
        }
        SwingUtilities.invokeLater(() -> {
            DemoPrefs.init(PREFS_ROOT_PATH);
            FlatLaf.registerCustomDefaultsSource("com.formdev.flatlaf.demo");
            DemoPrefs.setupLaf(args);
            FlatInspector.install("ctrl shift alt X");
            FlatUIDefaultsInspector.install("ctrl shift alt Y");
            DemoFrame frame = new DemoFrame();
            if (screenshotsMode) {
                frame.setPreferredSize(SystemInfo.isJava_9_orLater ? new Dimension(830, 440) : new Dimension(1660, 880));
            }
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        });
    }
}

